%------------------------------------------------------------------------------
% File     : SYO064^4.001 : TPTP v9.2.0. Released v4.0.0.
% Domain   : Logic Calculi (Intuitionistic logic)
% Problem  : ILTP Problem SYJ107+1.001
% Version  : [Goe33] axioms.
% English  :

% Refs     : [Goe33] Goedel (1933), An Interpretation of the Intuitionistic
%          : [Gol06] Goldblatt (2006), Mathematical Modal Logic: A View of
%          : [ROK06] Raths et al. (2006), The ILTP Problem Library for Intu
%          : [Ben09] Benzmueller (2009), Email to Geoff Sutcliffe
%          : [BP10]  Benzmueller & Paulson (2009), Exploring Properties of
% Source   : [Ben09]
% Names    : SYJ107+1.001 [ROK06]

% Status   : Theorem
% Rating   : 0.11 v9.1.0, 0.12 v9.0.0, 0.20 v8.2.0, 0.31 v8.1.0, 0.27 v7.5.0, 0.29 v7.4.0, 0.22 v7.2.0, 0.12 v7.1.0, 0.38 v7.0.0, 0.29 v6.4.0, 0.33 v6.3.0, 0.40 v6.2.0, 0.43 v6.1.0, 0.29 v5.5.0, 0.17 v5.4.0, 0.20 v5.1.0, 0.40 v5.0.0, 0.20 v4.1.0, 0.00 v4.0.1, 0.33 v4.0.0
% Syntax   : Number of formulae    :   47 (  20 unt;  23 typ;  19 def)
%            Number of atoms       :   84 (  19 equ;   0 cnn)
%            Maximal formula atoms :    9 (   3 avg)
%            Number of connectives :   73 (   3   ~;   1   |;   2   &;  65   @)
%                                         (   0 <=>;   2  =>;   0  <=;   0 <~>)
%            Maximal formula depth :    8 (   2 avg)
%            Number of types       :    2 (   0 usr)
%            Number of type conns  :   98 (  98   >;   0   *;   0   +;   0  <<)
%            Number of symbols     :   29 (  27 usr;   5 con; 0-3 aty)
%            Number of variables   :   40 (  31   ^;   7   !;   2   ?;  40   :)
% SPC      : TH0_THM_EQU_NAR

% Comments : This is an ILTP problem embedded in TH0
%------------------------------------------------------------------------------
include('Axioms/LCL010^0.ax').
%------------------------------------------------------------------------------
thf(a_type,type,
    a: $i > $o ).

thf(b_type,type,
    b: $i > $o ).

thf(c_type,type,
    c: $i > $o ).

thf(axiom1,axiom,
    ivalid @ ( iatom @ c ) ).

thf(axiom2,axiom,
    ivalid @ ( ior @ ( ior @ ( iatom @ b ) @ ( iatom @ a ) ) @ ( iatom @ b ) ) ).

thf(con,conjecture,
    ivalid @ ( ior @ ( iatom @ a ) @ ( iand @ ( iatom @ b ) @ ( iatom @ c ) ) ) ).

%------------------------------------------------------------------------------
